# Vertrag anlegen

Für die Neuanlage eines Vertrags ist die<span
style='font-weight:bold'> aktuelle Vertragsphase</span> relevant. Grundlegend lassen sich zwei Szenarien erläutern: Der Entwurf eines vollkommen neuen Vertrags auf Basis vordefinierter Vertragsvorlagen oder die Erfassung eines bereits bestehenden Vertrags bzw. einer bereits begonnenen Vertragsanbahnung. Aus diesem Grund kann die Wahl der aktuellen Vertragsphase beim Anlegen frei gewählt werden.

> <span
style='font-style:italic'>Am gestrigen Tag wurde von einem Vertriebsmitarbeiter ein Endkundenvertrag vom Typ &quot;</span><span
style='font-weight:bold;font-style:italic'>Kaufvertrag</span><span
style='font-style:italic'>&quot; abgeschlossen. Dieser wird eingescannt und als neuer </span><span
style='font-weight:bold;font-style:italic'>ausgehender</span><span
style='font-style:italic'> Vertrag im System abgelegt. Bei der Anlage des Vertrags wird der Status auf </span><span
style='font-weight:bold;font-style:italic'>Abgeschlossen</span><span
style='font-style:italic'> gesetzt, da die Unterschrift bereits vorliegt.</span>

> <span
style='font-style:italic'>In einer Verhandlungsrunde wurde beschlossen, einen neuen Rahmenvertrag zur Abnahme von Lizenzen abzuschließen. Es wird ein neuer </span><span
style='font-weight:bold;font-style:italic'>eingehender</span><span
style='font-style:italic'> Vertrag vom Typ </span><span style='font-weight:
bold;font-style:italic'>Rahmenvertrag</span><span style='font-style:italic'> angelegt. Dieser befindet sich noch im </span><span
style='font-weight:bold;font-style:italic'>Entwurf</span><span
style='font-style:italic'>-Status, da sich das Vertragsdokument zum gegenwärtigen Zeitpunkt in Bearbeitung befindet.</span>

Ein Vertrag, der angelegt wird, muss auf einem <a
href="#!/guide/p7B9917EA_3551_445E_A621_AF59E23AE8DF">Vertragstyp</a> basieren. Es können so jeweils passende Stammdaten vorbelegt werden, um dem Benutzer die Datenerfassung zu erleichtern. Beim Anlegen des Vertrags wird die Vorlage geklont. Im Laufe der weiteren Bearbeitung können weitere Daten hinzugefügt, Prozesse gestartet sowie Dokumente erzeugt werden.

Der neu angelegte Vertrag wird in eine <a
href="#!/guide/p551C5305_D9E1_41D7_9927_32EECF2E617B">Ablagestruktur</a> überführt, damit dieser jederzeit über den Archivbaum auffindbar ist.

## Aktion: Vertrag anlegen

Die Aktion kann im Reiter `Verträge` der Multifunktionsleiste aufgerufen werden. 

{@img img1.png}

Ab ELO 10 wird zusätzlich die Kachel <span
style='font-weight:bold'>Vertrag anlegen </span>angeboten.

{@img img3.png}

### Vorbedingungen

*   Verträge dürfen <span
style='font-weight:bold'>kontextlos</span> angelegt werden.
*   <span
style='font-weight:bold'>Vertragstyp</span> auswählen (nur falls mehrere Typen vorhanden).

### Dateneingabe

Für die Dateneingabe wird die Formular-Tab-Gruppe `002_create_contract` eingesetzt. 

{@img img5.png}

Diese setzt sich aus folgenden Bausteinen zusammen:

<table><thead><tr><td><span
style='font-weight:bold'>Vertragsdaten</span></td><td><span
style='font-weight:bold'>Laufzeit</span></td><td><span
style='font-weight:bold'>Vertragspartner</span></td><td><span
style='font-weight:bold'>Zahlungsplan</span></td></tr></thead><tbody><tr><td>210_general</td><td>310_duration</td><td>510_partner</td><td>410_payment</td></tr><tr><td>220_company</td><td></td><td>520_partner_address</td><td></td></tr><tr><td>230_contract_data</td><td></td><td>530_partner_contact</td><td></td></tr><tr><td>240_accounting</td><td></td><td></td><td></td></tr><tr><td>250_project</td><td></td><td></td><td></td></tr></tbody></table>

### Implementierung

<span class="tag_warning"><span
style='font-weight:bold'>Action definitions:</span> Definitionen der Aktion für die Clients finden sich in der Konfiguration `sol.contract.CreateContract`.</span>

Der <span
style='font-weight:bold'>technische Ablauf</span> wird durch die Index Server Aktion `sol.contract.ix.actions.CreateContract` implementiert. Diese klont ein neues Element auf Basis des ausgewählten Vertragstyps in der Chaosablage und startet den Workflow `sol.contract.contract.create`.

Im Erfolgsfall werden folgende Events an den Client übermittelt:

<table><thead><tr><td>Event</td><td>Beschreibung</td><td>Status</td></tr></thead><tbody><tr><td>DIALOG</td><td>Zeigt das Formular zur Dateneingabe in einem Dialog an.</td><td></td></tr><tr><td>GOTO</td><td>Zeigt das neu angelegte Element im Client an.</td><td></td></tr></tbody></table>

<span
style='font-weight:bold'>Beschreibung des Workflows</span>

{@img img7.png}

<table><thead><tr><td><span
style='font-weight:bold'>Knotenbezeichnung</span></td><td><span
style='font-weight:bold'>Knotenname deutsch und Beschreibung</span></td><td><span
style='font-weight:bold'>Funktion</span></td></tr></thead><tbody><tr><td><span
style='font-weight:bold'>Data entry</span></td><td><span
style='font-weight:bold'>Vertrag anlegen</span><br />Benutzerknoten: Anlegen eines neuen Vertrags durch den Eigentümer</td><td></td></tr><tr><td><span
style='font-weight:bold'>MOVE: contract</span></td><td><span
style='font-weight:bold'>MOVE: Vertrag</span><br />Verteilungsknoten: Verschiebt das Vertrags-SORD in ein anderes Verzeichnis</td><td>sol.common.ix.functions.Move</td></tr><tr><td><span
style='font-weight:bold'>GENERATOR: contract no.</span></td><td><span
style='font-weight:bold'>GENERATOR: Vertragsnummer</span><br />Verteilungsknoten: Erzeugt eine interne Vertragsnummer</td><td>sol.contract.ix.functions.generators.GenerateContractNo</td></tr><tr><td><span
style='font-weight:bold'>GENERATOR: short description</span></td><td><span
style='font-weight:bold'>GENERATOR: Kurzbezeichnung</span><br />Verteilungsknoten: Passt die Kurzbezeichnung des Vertrags an</td><td>sol.contract.ix.functions.generators.GenerateContractShortDesc</td></tr><tr><td><span
style='font-weight:bold'>FEED: contract created</span></td><td><span
style='font-weight:bold'>FEED: Vertrag angelegt</span><br />Verteilungsknoten: Legt einen Feed-Eintrag zum Anlegen des Vertrags an</td><td>sol.common.ix.functions.FeedComment</td></tr><tr><td><span
style='font-weight:bold'>DELETE: temporary record</span></td><td><span
style='font-weight:bold'>DELETE: temporary record</span><br />Verteilungsknoten: Löscht das SORD Objekt aus der Chaosablage</td><td>sol.common.ix.functions.Delete</td></tr></tbody></table>
